#version 330
#extension GL_EXT_gpu_shader4 : enable
// Relax_Night Shader EditionMod01.fsh  by   Canilho

//https://www.shadertoy.com/view/lldXRB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// This was a self learning study of an animation of
	// inigo quilez 
	// Big thanks for the inspiration
	// https://www.shadertoy.com/view/ldXXDj
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float fbm( vec2 p )
{
    return 0.5000*texture( iChannel0, p*1.00 ).x + 
           0.2500*texture( iChannel0, p*2.02 ).x + 
           0.1250*texture( iChannel0, p*4.02 ).x + 
           0.0675*texture( iChannel0, p*8.02 ).x;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float time = mod( iTime, 458.0 );
	vec2 p = (-iResolution.xy+2.0*gl_FragCoord.xy) / iResolution.y;
    vec2 i = p;

    // camera
    p += vec2(1.0,3.0)*0.002*2.0*cos( iTime*2.0 + vec2(0.0,1.5) );    
    p += vec2(1.0,3.0)*0.001*1.0*cos( iTime*5.0 + vec2(1.0,4.5) );    
    p *= 0.95 + 0.05*length(p);
    float an = 0.03*sin( 0.1*time );
    float co = cos(an);
    float si = sin(an);
    p = mat2( co, -si, si, co )*p;
    
    // water
    vec2 q = vec2(p.x,1.0)/p.y;
    q.y -= 0.3*time;    
    vec2 off = texture2D( iChannel0, 0.5*(mod(time*0.0001,2.0))*q*vec2(1.0,2.0) - vec2(0.0,0.007*time) ).xy;
    q += 0.4*(-1.0 + 5.0*off);
    vec3 col = texture2D( iChannel0, 0.8*q*(mod(time*0.001,2.0)) *vec2(.5,8.0) + vec2(0.0,0.01*time) ).zyx;
    col *= 0.4;
    float re = 1.0-smoothstep( 0.0, 0.7, abs(p.x-0.6) - abs(p.y)*0.3+0.2 );
    col += 1.0*vec3(1.0,0.9,0.73)*re*0.2*off.y*5.0*(1.0-col.x);
    float re2 = 1.0-smoothstep( 0.0, 2.0, abs(p.x-0.6) - abs(p.y)*0.85 );

    
    // sky
    vec3 sky = vec3(0.01,0.03,0.1);
    // stars    
    sky += 0.8*smoothstep( 0.90,1.0,texture( iChannel3, 2.5*p+time*0.03 ).x);
    sky += 0.4*smoothstep( 0.50,1.0,texture( iChannel3, 2.5*p+time*0.1 ).y);
    sky += 0.3*pow(abs(0.5-max(0.0,p.y)),5.0);
    
    // clouds    
    float f = fbm( 0.002*vec2(p.x,1.0)/p.y );
    vec3 cloud = vec3(0.3,0.4,0.5)*0.7*(1.0-0.85*sqrt(smoothstep(0.4,1.0,f)));
    sky = mix( sky, cloud, 0.95*smoothstep( 0.4, 0.6, f ) );
    sky = mix( sky, vec3(0.33,0.34,0.35), pow(1.0-max(0.0,p.y),2.0) );
    col = mix( col, sky, smoothstep(0.0,0.1,p.y) );

    // moon
    	// position
        float d = length(p-vec2(0.58,0.5));
    
        float g = .8 - smoothstep( 0.2, 0.21 , d-0.010*time*0.05 );
        float moontex = 0.8+0.2*smoothstep(0.25,0.7,fbm(0.06*p));
        vec3 moon = vec3(1.0,0.97,0.9);
    
        col += moon*exp(-2.*d);
      
        col = mix( col, moon*moontex, g );
    
    // horizon
    col += 0.2*cos(time/120.0)*pow(clamp(1.0-abs(p.y),0.0,1.0),9.0);
    
    // postprocess
    col *= 1.4;
    col = pow( col, vec3(1.5,1.2,1.0) );    
    col *= clamp(1.0-0.3*length(i), 0.0, 1.0 );

    // fade 
    	// Initial fade from  0 to 4 seconds
    	col *=       smoothstep(  0.0,  4.0, time );
    	// End song 443 seconds + 4 seconds of fade
	    col *= 1.0 - smoothstep( 443.0, 447.0, time );

    gl_FragColor = vec4( col, 2.0 );
}